/**
* Script: player.js
* Written by: Radnen
* Updated: 1/16/2011
**/

function Player() {
	this.ships = [new PlayerShip(Ships[0])];
	this.ship = this.ships[0];
	this.curship = 0;
	this.days = 0;
	this.credits = 0;
	this.inventory = [];
	this.quests = [];
	this.travelTo = [];
		
	this.save = function(file) {
		this.ships[this.curship] = this.ship;
		Utility.saveObject(this, file, "player");
	}
	
	this.load = function(file) {
		Utility.loadObject(this, file, "player");
		var old_list = Utility.getSavedObject(file, "player", "ships");
		this.ships = [];
		for (var i = 0; i < old_list.length; ++i) this.ships[i] = new PlayerShip();
		Utility.set(this.ships, old_list);
		this.ship = this.ships[0];
	}

	this.updateQuestDays = function(num) {
		if (!num) num = 1;
		this.days == num;
		var i = this.quests.length;
		var quest = null;
		while(i--) {
			quest = this.quests[i];
			quest.days -= num;
			if (quest.days == 0 && quest.type == QUEST_BOUNTY) {
				this.quests.splice(i, 1);
				i++;
			}
		}
	}

	this.updateEscortQuests = function(condition, planet) {
		var i = this.quests.length, quest;
		while(i--) {
			quest = this.quests[i];
			if (quest.type != QUEST_ESCORT) continue;
			if (quest.escortCondition == condition) {
				if (condition == HATES_PLANET) {
					if (planet == quest.hatesPlanet) quest.condition = true;
				}
				else quest.condition = true;
			}
		}
	}
	
	this.addBountyShips = function() {
		var i = this.quests.length;
		while(i--) {
			if (this.quests[i].type == QUEST_BOUNTY) {
				if (this.quests[i].system != Genesis.currentWorld) continue;
				var ship = CreateBountyShip(this.quests[i]);
				ship.x = -2000+Utility.random(4000);
				ship.y = -2000+Utility.random(4000);
				Genesis.ships.push(ship);
			}
		}
	}
	
	this.updateBountyQuest = function(name) {
		var i = this.quests.length;
		while(i--) {
			if (this.quests[i].type == QUEST_BOUNTY) {
				if (this.quests[i].shipname == name && this.quests[i].system == Genesis.currentWorld) {
					this.quests[i].finished = true; return;
				}
			}
		}
	}
}

function PlayerShip(ship) {
	this.inherit = ShipEntity;
	this.inherit();
	
	this.x = SW/2;
	this.y = SH/2;
	
	this.last_a = new Angle();
	this.last_a.degrees = 180;
	this.last_set = true;
	this.upkey = true;
	
	this.hull = null;
	this.thusters = null;
	this.computer = null;
	
	this.afterJump = function() {
		Audio.playSound(Resources.sounds.boom);
		this.maxspeed = this.lastspeed;
		Genesis.loadGameWorld(Genesis.player.travelTo[0]);
		StarChart.selectedSystem = null;
		StarChart.nextSys = 0;
		this.x = Planets[GameWorlds[Genesis.currentWorld].planets[0]].x-this.vx*200;
		Camera.x = -this.x+SW/2;
		this.y = Planets[GameWorlds[Genesis.currentWorld].planets[0]].y-this.vy*200;
		Camera.y = -this.y+SH/2;
		this.wh_x = this.x-12;
		this.wh_y = this.y-48;
		this.last_a.degrees = this.a.degrees-180;
		this.jumps.value--;
		Genesis.player.updateQuestDays();
	}
	
	this.canEquip = function(item) {
		if (item instanceof Weapon) {
			if (item.type == GUN) return true;
			if (item.type == ROCKET && this.secondary.item > -2) return true;
		}
		else return true;
		return false;
	}
	
	this.input = function() {
		if (Genesis.useMouse) this.mouseInput();
		else this.keyboardInput();
	}
	
	this.mouseInput = function() {
		this.a.degrees = Math.floor((Math.atan2(Cursor.screenY-this.y, Cursor.screenX-this.x)/Math.PI*180)/5)*5;
		
		if (Cursor.onLeftHold()) {
			this.updateVelocity();
			this.thrust = true;
		}
		else this.resetThrust();
		
		if (Cursor.onRightClick()) this.firePrimary();
	}
	
	this.load = function(file) {
		var obj = JSON.parse(file.read("Player", "{}"));
		for (var i in obj) this[i] = obj[i];
		this.a = new Angle(this.a);
		this.last_a = new Angle(this.last_a);
		this.target_a = new Angle(this.target_a);
		Camera.x = file.read("CamX", 0);
		Camera.y = file.read("CamY", 0);
		this.x = SW/2-Camera.x;
		this.y = SH/2-Camera.y;
	}
	
	this.keyboardInput = function() {
		if (IsKeyPressed(KEY_LEFT)) {
			this.turnLeft();
			this.last_a.degrees = this.a.degrees-180;
		}

		if (IsKeyPressed(KEY_RIGHT)) {
			this.turnRight();
			this.last_a.degrees = this.a.degrees-180;
		}
		
		if (IsKeyPressed(KEY_UP)) {
			this.updateVelocity();
			this.thrust = true;
			this.upkey = false;
		}
		else if (!this.upkey) {
			if (Math.floor(this.speed+0.25) == 0) { this.vx = 0; this.vy = 0; }
			this.resetThrust();
			this.upkey = true;
		}
		
		this.shielded = (IsKeyPressed(KEY_SHIFT) && this.shields.value > 0);
		
		if (IsKeyPressed(KEY_DOWN)) {
			this.turnToTarget(this.last_a);
		}
		
		if (IsKeyPressed(KEY_SPACE)) this.firePrimary();
		if (IsKeyPressed(KEY_CTRL)) this.fireSecondary();
		if (IsKeyPressed(KEY_H) && StarChart.selectedSystem && this.jumps.value > 0) {
			Genesis.player.travelTo[0] = StarChart.selectedSystem.name;
			this.hyperJump(StarChart.selectedSystem);
		}
	}
	
	this.deathTimer = 0;
	this.doDeath = function() {
		if (this.deathTimer == 0) {
			this.vx = 0;
			this.vy = 0;
			Audio.playSound(Resources.sounds.bigboom);
			ParticleEngine.explode(this.x, this.y, 5, 1000, 2, CreateColor(255, 255, 255), Resources.images.steel);
			ParticleEngine.explode(this.x, this.y, 10, 1000, 0.25, CreateColor(255, 255, 255), Resources.images.fire);
			this.deathTimer = GetTime();
		}
		if (this.deathTimer + 3500 < GetTime()) {
			var deathstate = new TextState("And so you die in your perilous quest to save mankind. Goodbye, loyal cadet.\n\n"+
			"You can choose to load your last autosave, start a new game, or quit.");
			deathstate.onOkay.add(function() {
				this.hide();
				StateManager.purgeStates();
				menustate.show();
			});
			deathstate.show();
		}
	}
	
	this.update = function() {
		if (this.hp.value <= 0) this.doDeath();
		else {
			this.draw();
			Camera.x -= this.vx;
			Camera.y -= this.vy;
			if (this.jump != 0) { this.doJump(); return; }
			this.input();
		}
	}
	
	if (ship) this.setupShip(ship);
	else this.setupShip(Ships[0]);
}